<?php
$ASSETS = "/poker/assets/skin/default";

/* Paytable placeholder */
$paytable = [
  ['Royal Straight Flush', '200.000'],
  ['Straight Flush', '80.000'],
  ['Quadra (Four of a Kind)', '50.000'],
  ['Full House', '10.000'],
  ['Flush', '7.000'],
  ['Sequência (Straight)', '5.000'],
  ['Trinca (Three of a Kind)', '3.000'],
  ['Dois Pares (Two Pairs)', '2.000'],
];

?><!doctype html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>GLJET • VideoPoker (Layout do XD)</title>
  <link rel="stylesheet" href="/poker/style.css?v=xd-grid52-2">
</head>
<body>

  <!-- Topo com logo -->
  <div class="topbar">
    <div class="inner">
      <div class="logo"><img src="<?=$ASSETS?>/logo.svg" alt="Logo"></div>
    </div>
  </div>

  <div class="wrap">

    <!-- KPIs -->
    <div class="panel">
      <div class="kpis">
        <div class="kpi"><small>Créditos</small><strong>1.000,00</strong></div>
        <div class="kpi"><small>Aposta</small><strong>10,00</strong></div>
        <div class="kpi"><small>Extra</small><strong>2,00</strong></div>
        <div class="kpi"><small>Ganhos</small><strong>0,00</strong></div>
      </div>
    </div>

    <!-- Paytable -->
    <div class="panel">
      <div class="section-title">Tabela de Premiação</div>
      <div class="paytable">
        <?php foreach($paytable as $row): ?>
          <div class="pay-row"><b><?=htmlspecialchars($row[0])?></b><span><?=htmlspecialchars($row[1])?></span></div>
        <?php endforeach; ?>
      </div>
    </div>

    <!-- DECK 52 conforme XD: 11/11/11/11/8 (todas fechadas) -->
    <div class="panel deck">
      <div class="section-title">Cartas (viradas)</div>
      <div class="deck-rows" id="deck52">
        <?php
          $counts = [11,11,11,11,8]; $idx=0;
          foreach($counts as $i=>$n){
            $last = ($i===4)?' last':'';
            echo "<div class='deck-row$last' style='--cols:$n'>";
            for($j=0;$j<$n;$j++){
              $idx++;
              echo "<div class='cardwrap sm' data-idx='$idx'>
                      <div class='card card--closed' style=\"background-image:url('{$ASSETS}/cards/BACK.svg')\"></div>
                      <div class='idx'>$idx</div>
                    </div>";
            }
            echo "</div>";
          }
        ?>
      </div>
    </div>

    <!-- Mensagem -->
    <div class="panel">
      <div class="msgbar" id="msg">Mensagem: Clique em <b>JOGAR</b> para abrir as 5 primeiras cartas (mock visual).</div>
    </div>

    <!-- Mão (5 grandes) — vazia até JOGAR -->
    <div class="panel hand">
      <div class="section-title">Sua mão</div>
      <div class="grid5" id="hand5">
        <?php for($i=0;$i<5;$i++): ?>
          <div class="cardwrap">
            <div class="card card--closed placeholder" style="background-image:url('<?=$ASSETS?>/cards/BACK.svg')"></div>
            <div class="cardlabel">—</div>
          </div>
        <?php endfor; ?>
      </div>
    </div>

    <!-- Botões -->
    <div class="panel">
      <div class="actions">
        <button class="btn secondary" type="button" disabled>APOSTA</button>
        <button class="btn" type="button" id="btnPlay">JOGAR</button>
        <button class="btn warn" type="button" disabled>ABRIR</button>
        <button class="btn secondary" type="button" disabled>PARAR</button>
        <button class="btn secondary" type="button">AJUDA</button>
      </div>
    </div>

  </div>

  <!-- JS: abre 5 cartas (mock) e marca as 5 primeiras da grade -->
  <script>
  (function(){
    const ASSETS = "<?=$ASSETS?>";
    const hand = document.getElementById('hand5');
    const deck = document.getElementById('deck52');
    const btn = document.getElementById('btnPlay');
    const msg = document.getElementById('msg');

    const demo5 = ['AS','KH','QD','JC','10S']; // só visual

    btn.addEventListener('click', () => {
      const slots = hand.querySelectorAll('.cardwrap');
      slots.forEach((wrap, i) => {
        const code = demo5[i] || 'AS';
        const img = wrap.querySelector('.card');
        const lab = wrap.querySelector('.cardlabel');
        img.classList.remove('placeholder','card--closed');
        img.classList.add('card--open');
        img.style.backgroundImage = "url('"+ASSETS+"/cards/"+code+".svg')";
        lab.textContent = code.replace(/[SHDC]/,' ')
                              .replace('S','♠').replace('H','♥').replace('D','♦').replace('C','♣');
      });

      // marca 5 primeiras da grade (apenas visual)
      let marked = 0;
      deck.querySelectorAll('.deck-row .card').forEach(card => {
        if (marked < 5) { card.classList.add('card--open'); card.style.backgroundImage = "url('"+ASSETS+"/cards/BACK.svg')"; card.classList.add('card--used'); marked++; }
      });

      btn.disabled = true;
      msg.innerHTML = '5 cartas abertas (mock). Layout conforme XD (grade 11/11/11/11/8).';
    });
  })();
  </script>
</body>
</html>
