<?php
require __DIR__ . '/_bootstrap.php';
$holds = $body['holds'] ?? null;
if (!is_array($holds) || count($holds) !== 5) bad_request('holds inválido');
if (!isset($_SESSION['game'])) bad_request('Sessão não iniciada');
$g = &$_SESSION['game'];
if (!empty($g['finished'])) bad_request('Jogo já finalizado');

$g['holds'] = array_map('boolval', $holds);

// betBase atual (APÓS últimas trocas, vale o round corrente)
$betBase = betAt($g['k'], (int)$g['bet0'], (float)$g['alpha'], (float)$g['cap_multiplier']);
$prospects = prospects_with_payouts($g['hand5'], $g['holds'], $betBase);

// também devolve paytable detalhada com base no bet atual
$pt = paytable(); $ptRows=[];
foreach($pt as $name=>$mult){ $ptRows[]=['rank'=>$name,'mult'=>$mult,'payout'=>$mult*$betBase]; }

echo json_encode([
  'ok'=>true,
  'betBase' => $betBase,
  'prospects' => $prospects,
  'paytableDetailed' => $ptRows
], JSON_UNESCAPED_UNICODE);
