<?php
require __DIR__ . '/_bootstrap.php';

$bet0 = isset($body['bet0']) ? (int)$body['bet0'] : 100;
$clientSeed = isset($body['clientSeed']) ? (string)$body['clientSeed'] : bin2hex(random_bytes(8));

if (!isset($_SESSION['wallet_balance'])) {
  $_SESSION['wallet_balance'] = (int)$config['initial_balance'];
}

$serverSeed = random_bytes(32);
$serverSeedHash = sha256_hex($serverSeed);
$nonce = 0;

$deck = range(0, 51);
$deck = shuffleProvably($deck, $serverSeed, $clientSeed, $nonce);
$hand5 = array_slice($deck, 0, 5);
$remaining47 = array_slice($deck, 5);
$takenMask47 = array_fill(0, 47, false);

$_SESSION['game'] = [
  'bet0' => $bet0,
  'alpha' => (float)$config['alpha'],
  'cap_multiplier' => (float)$config['cap_multiplier'],
  'risk_base_rate' => (float)$config['risk_base_rate'],
  'risk_cap' => (float)$config['risk_cap'],
  'max_exchanges' => (int)$config['max_exchanges'],
  'serverSeed' => bin2hex($serverSeed),
  'serverSeedHash' => $serverSeedHash,
  'clientSeed' => $clientSeed,
  'nonce' => $nonce,
  'hand5' => $hand5,
  'remaining47' => $remaining47,
  'takenMask47' => $takenMask47,
  'holds' => [false,false,false,false,false],
  'k' => 0,
  'finished' => false,
  'total_bet' => 0,
  'total_risk' => 0
];

$betNow = betAt(0, $bet0, (float)$config['alpha'], (float)$config['cap_multiplier']);
$riskNow = risk_fee_for($hand5, $betNow, (float)$config['risk_base_rate'], (float)$config['risk_cap']);
$debitNow = $betNow + $riskNow;
if ($_SESSION['wallet_balance'] < $debitNow) bad_request('Saldo insuficiente');
$_SESSION['wallet_balance'] -= $debitNow;
$_SESSION['game']['total_bet']  += $betNow;
$_SESSION['game']['total_risk'] += $riskNow;

// preview atual
$prev = hand_rank_and_mult($hand5);
$previewRank = $prev['rank']; $previewMult = (int)$prev['mult'];
$previewBetBase = $betNow; $previewPayout = $previewMult * $previewBetBase;

// paytable com valores para a aposta da rodada
$pt = paytable(); $ptRows=[];
foreach($pt as $name=>$mult){ $ptRows[]=['rank'=>$name,'mult'=>$mult,'payout'=>$mult*$betNow]; }

// prospects (com holds=nenhum ainda será vazio, e tudo bem)
$prospects = prospects_with_payouts($hand5, [false,false,false,false,false], $betNow);

echo json_encode([
  'serverSeedHash' => $serverSeedHash,
  'nonce' => $nonce,
  'hand5' => $hand5,
  'remainingCount' => 47,
  'k' => 0,
  'betNow' => $betNow,
  'riskNow' => $riskNow,
  'debitNow' => $debitNow,
  'totalBet' => $_SESSION['game']['total_bet'],
  'totalRisk' => $_SESSION['game']['total_risk'],
  'totalDebited' => $_SESSION['game']['total_bet'] + $_SESSION['game']['total_risk'],
  'balance' => $_SESSION['wallet_balance'],
  'previewRank' => $previewRank,
  'previewMultiplier' => $previewMult,
  'previewBetBase' => $previewBetBase,
  'previewPayout' => $previewPayout,
  'paytableDetailed' => $ptRows,
  'prospects' => $prospects
], JSON_UNESCAPED_UNICODE);
