<?php
require __DIR__ . '/_bootstrap.php';
if (!isset($_SESSION['game'])) bad_request('Sessão não iniciada');

$g = &$_SESSION['game'];
if (!empty($g['finished'])) bad_request('Jogo já finalizado');
if ($g['k'] >= $g['max_exchanges']) bad_request('Limite de trocas atingido');

$picks = $body['picks'] ?? [];
if (!is_array($picks)) bad_request('picks inválido');
if (count($picks) !== count(array_unique($picks))) bad_request('Picks repetidos não são permitidos');

$newHand = applyDraw($g['hand5'], $g['holds'], $g['remaining47'], $g['takenMask47'], $picks);
$g['hand5'] = $newHand;
$g['k'] = (int)$g['k'] + 1;

$betNow  = betAt($g['k'], (int)$g['bet0'], (float)$g['alpha'], (float)$g['cap_multiplier']);
$riskNow = risk_fee_for($g['hand5'], $betNow, (float)$g['risk_base_rate'], (float)$g['risk_cap']);
$debitNow = $betNow + $riskNow;

if ($_SESSION['wallet_balance'] < $debitNow) bad_request('Saldo insuficiente');
$_SESSION['wallet_balance'] -= $debitNow;
$g['total_bet']  += $betNow;
$g['total_risk'] += $riskNow;

// preview pós-troca
$prev = hand_rank_and_mult($g['hand5']);
$previewRank = $prev['rank']; $previewMult = (int)$prev['mult'];
$previewBetBase = $betNow; $previewPayout = $previewMult * $previewBetBase;

// paytable detalhada (rodada atual)
$pt = paytable(); $ptRows=[];
foreach($pt as $name=>$mult){ $ptRows[]=['rank'=>$name,'mult'=>$mult,'payout'=>$mult*$betNow]; }

// prospects com HOLD atual
$prospects = prospects_with_payouts($g['hand5'], $g['holds'], $betNow);

echo json_encode([
  'newHand' => $g['hand5'],
  'k' => $g['k'],
  'betNow' => $betNow,
  'riskNow' => $riskNow,
  'debitNow' => $debitNow,
  'totalBet' => $g['total_bet'],
  'totalRisk' => $g['total_risk'],
  'totalDebited' => $g['total_bet'] + $g['total_risk'],
  'balance' => $_SESSION['wallet_balance'],
  'takenMask47' => $g['takenMask47'],
  'previewRank' => $previewRank,
  'previewMultiplier' => $previewMult,
  'previewBetBase' => $previewBetBase,
  'previewPayout' => $previewPayout,
  'paytableDetailed' => $ptRows,
  'prospects' => $prospects
], JSON_UNESCAPED_UNICODE);
