<?php
header('Content-Type: application/json; charset=UTF-8');
header("Access-Control-Allow-Origin: *");

// Caminho base das imagens e links
$_caminho = "https://gljet.com/playfantasy/games/";

// Credenciais do banco
define("Host", "157.230.9.103");
define("User", "jp112");
define("Password", "mDB@4hHj097OoP");
define("Database", "jp112");

// Conexão MySQL
$db = mysqli_connect(Host, User, Password, Database);
if (!$db) {
    http_response_code(500);
    echo json_encode(["status" => "ERROR", "message" => "Erro ao conectar ao banco de dados."]);
    exit;
}

// Função para buscar os jogos
function pastaimg($db, $_caminho) {
    $resposta = [];

    $sql = "SELECT 
                name, 
                category, 
                CONCAT('imagens/', IF(pasta='', 'geral', pasta), '/380x380.png') AS image, 
                game_id 
            FROM gamelist 
            ORDER BY ordem, name;";

    $result = mysqli_query($db, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $resposta[] = [
                "category" => $row["category"],
                "image"    => $_caminho . $row["image"],
                "name"     => $row["name"],
                "url"      => $_caminho . "opengame.php?id=" . $row["game_id"]
            ];
        }
    } else {
        $resposta = [
            [
                "category" => "casino",
                "image"    => $_caminho . "imagens/geral/380x380.png",
                "name"     => "Casino",
                "url"      => $_caminho
            ]
        ];
    }

    return $resposta;
}

// Busca os jogos
$games = pastaimg($db, $_caminho);

// Retorna o JSON formatado
echo json_encode(["status" => "OK", "games" => $games], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

mysqli_close($db);
?>