<?php
require __DIR__ . '/inc/db.php';
require __DIR__ . '/inc/auth.php';
require_login();
?>
<!doctype html>
<html lang="pt-br" data-bs-theme="light">
<head>
  <meta charset="utf-8">
  <title>Consulta — GLJET</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="/consulta/assets/style.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-light bg-white border-bottom sticky-top">
  <div class="container-fluid">
    <button class="btn btn-outline-secondary" id="btnSidebar"><span class="navbar-toggler-icon"></span></button>
    <div class="d-flex align-items-center gap-2 flex-grow-1 ms-2">
      <div class="text-nowrap small text-muted">Comando:</div>
      <input id="commandPrefix" class="form-control form-control-sm" style="max-width:130px" value="/cpf" readonly>
      <input id="commandArgs" class="form-control form-control-sm" placeholder="[ digite o filtro ]">
      <button id="btnBuscar" class="btn btn-primary btn-sm">Procurar</button>
    </div>
      <!--
    <div class="d-flex align-items-center gap-3">
      <span class="small text-muted">Olá, <?= htmlspecialchars($_SESSION['uname'] ?? ''); ?></span>
      <a class="btn btn-outline-danger btn-sm" href="/consulta/logout.php">SAIR</a>
    </div> -->
  </div>
</nav>

<div class="d-flex">
  <!-- Sidebar -->
  <aside id="sidebar" class="border-end">
    <div class="p-3">
      <div class="fw-bold mb-2">MENU</div>
      <ul class="list-unstyled sidebar-menu">
        <li><button data-cmd="/cpf" class="link-dark sidebar-link">CPF</button></li>
        <!--<li><button data-cmd="/numero" class="link-dark sidebar-link">TELEFONE</button></li>
        <li class="mt-2 fw-bold small">NOME</li>
        <li><button data-cmd="/nome1" class="link-dark sidebar-link">NOME COMPLETO</button></li>
        <li><button data-cmd="/nome2" class="link-dark sidebar-link">nome semelhante/abreviado</button></li>
        <li><button data-cmd="/nome3" class="link-dark sidebar-link">nome e os digitos no CPF</button></li>
        <li><button data-cmd="/nome4" class="link-dark sidebar-link">nome e o estado onde mora</button></li>
        <li class="mt-2"><button data-cmd="/bin" class="link-dark sidebar-link">BIN</button></li>-->
        <li class="mt-2"><a href="/consulta/logout.php" class="link-danger sidebar-link">SAIR</a></li>
      </ul>
    </div>
  </aside>

  <!-- Conteúdo -->
  <main class="flex-grow-1 p-3">
    <div id="explain" class="small text-muted mb-2"></div>
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div class="small" id="resultInfo">Pronto.</div>
      <div class="d-flex gap-2">
        <button id="btnExport" class="btn btn-outline-secondary btn-sm" disabled>Exportar TXT</button>
      </div>
    </div>
    <pre id="resultBox" class="p-3 bg-light border rounded small" style="min-height:280px; white-space:pre-wrap;"></pre>
    <div class="d-flex justify-content-between align-items-center mt-2">
      <button id="prevPage" class="btn btn-outline-secondary btn-sm" disabled>&laquo; Anterior</button>
      <div class="small" id="pageLabel">Página 1</div>
      <button id="nextPage" class="btn btn-outline-secondary btn-sm" disabled>Próxima &raquo;</button>
    </div>
    <footer class="text-center text-muted small mt-3">GLJET Consulta — v1 (Bootstrap 5)</footer>
  </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="/consulta/assets/app.js"></script>
</body>
</html>