<?php
$cfg = include __DIR__.'/../../config.php';
$data = $data ?? [];
$p = $data['profile'] ?? [];
$links = $data['links'] ?? [];
$posts = $data['posts'] ?? [];
$photos = $data['photos'] ?? [];
$accent = $p['accent'] ?? '#22c55e';
$name = $p['name'] ?? 'Cartão Digital';
$avatar = $p['avatar'] ?? '';
$title = $p['title'] ?? '';
$location = $p['location'] ?? '';
$locale = defined('ACTIVE_LOCALE') ? ACTIVE_LOCALE : ($cfg['default_locale'] ?? 'pt-BR');

// descobrir quantos perfis existem p/ este user (para montar seletor)
$pdo = db();
$available = $pdo->prepare("SELECT locale FROM user_profiles_i18n WHERE user_id=? ORDER BY FIELD(locale,'pt-BR','en-US','es-419')");
$available->execute([$ctx['user_id']]);
$locales = array_column($available->fetchAll(), 'locale');
?><!doctype html><html lang="<?php echo htmlspecialchars($locale); ?>"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?php echo htmlspecialchars($name); ?></title>
<link rel="stylesheet" href="<?php echo htmlspecialchars($cfg['base_url']); ?>/assets/css/tap.css">
<meta name="theme-color" content="<?php echo htmlspecialchars($accent); ?>">
<style>:root{--accent: <?php echo htmlspecialchars($accent); ?>}</style>
</head><body>
<section class="hero">
  <?php if ($avatar): ?><img class="avatar" src="<?php echo htmlspecialchars($avatar); ?>" alt="avatar"><?php endif; ?>
  <h1 class="name"><?php echo htmlspecialchars($name); ?></h1>
  <p class="role"><?php echo htmlspecialchars($title); ?></p>

  <div class="badges">
    <?php if ($location): ?><span class="badge">📍 <?php echo htmlspecialchars($location); ?></span><?php endif; ?>
    <span class="badge">⚡ <?php echo tr('scan_tip',$locale); ?></span>
    <?php if (count($locales) > 1): ?>
      <span class="badge">
        <?php echo tr('lang',$locale); ?>:
        <?php foreach ($locales as $i => $lc): ?>
          <a href="?k=<?php echo urlencode(PUBLIC_TOKEN); ?>&lang=<?php echo urlencode($lc); ?>" style="margin-left:6px;<?php echo $lc===$locale?'text-decoration:underline;':'';?>">
            <?php echo htmlspecialchars($lc); ?>
          </a>
          <?php if ($i < count($locales)-1) echo ' · '; ?>
        <?php endforeach; ?>
      </span>
    <?php endif; ?>
  </div>

  <div class="actions">
    <?php if (!empty($p['whatsapp'])): ?>
      <a class="btn" href="https://wa.me/<?php echo rawurlencode(preg_replace('~\\D+~','',$p['whatsapp'])); ?>" target="_blank"><?php echo tr('whatsapp',$locale); ?></a>
    <?php endif; ?>
    <?php if (!empty($p['phone'])): ?>
      <a class="btn" href="tel:<?php echo htmlspecialchars(preg_replace('~\\s+~','',$p['phone'])); ?>"><?php echo tr('call',$locale); ?></a>
    <?php endif; ?>
    <?php if (!empty($p['email'])): ?>
      <a class="btn" href="mailto:<?php echo htmlspecialchars($p['email']); ?>"><?php echo tr('email',$locale); ?></a>
    <?php endif; ?>
    <button class="btn alt" onclick="shareCard()"><?php echo tr('share',$locale); ?></button>
  </div>

  <div class="socials">
    <?php foreach (['website'=>'🌐','instagram'=>'📷','facebook'=>'📘','tiktok'=>'🎵','youtube'=>'▶️','linkedin'=>'💼','x'=>'𝕏'] as $k=>$icon):
      $u=$links[$k] ?? ''; if($u): ?>
      <a href="<?php echo htmlspecialchars($u); ?>" target="_blank"><?php echo $icon; ?></a>
    <?php endif; endforeach; ?>
  </div>
</section>

<main class="container">
  <?php if (!$data): ?>
    <section class="section"><p><?php echo tr('no_profile',$locale); ?></p></section>
  <?php endif; ?>

  <?php if (!empty($posts)): ?>
  <section class="section">
    <h2><?php echo tr('updates',$locale); ?></h2>
    <div class="grid">
      <?php foreach ($posts as $post): ?>
        <article class="post">
          <h3><?php echo htmlspecialchars($post['title'] ?? ''); ?></h3>
          <small><?php echo htmlspecialchars(date('d/m/Y', strtotime($post['date'] ?? 'now'))); ?></small>
          <p><?php echo nl2br(htmlspecialchars($post['body'] ?? '')); ?></p>
        </article>
      <?php endforeach; ?>
    </div>
  </section>
  <?php endif; ?>

  <?php if (!empty($photos)): ?>
  <section class="section">
    <h2><?php echo tr('gallery',$locale); ?></h2>
    <div class="grid">
      <?php foreach ($photos as $ph): ?>
        <div class="tile">
          <img src="<?php echo htmlspecialchars($ph['path'] ?? ''); ?>" alt="<?php echo htmlspecialchars($ph['caption'] ?? ''); ?>">
          <?php if(!empty($ph['caption'])): ?><small><?php echo htmlspecialchars($ph['caption']); ?></small><?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php endif; ?>

  <section class="section">
    <h2><?php echo tr('contact_me',$locale); ?></h2>
    <form class="lead" onsubmit="return sendLead(this)">
      <input name="name" placeholder="<?php echo htmlspecialchars(tr('ph_name',$locale)); ?>">
      <input name="email" type="email" placeholder="<?php echo htmlspecialchars(tr('ph_email',$locale)); ?>">
      <input name="phone" placeholder="<?php echo htmlspecialchars(tr('ph_phone',$locale)); ?>">
      <textarea name="note" rows="3" placeholder="<?php echo htmlspecialchars(tr('ph_message',$locale)); ?>"></textarea>
      <button><?php echo tr('send',$locale); ?></button>
    </form>
    <p id="lead-ok" style="display:none;color:#86efac;margin-top:6px">✔️ <?php echo tr('thanks',$locale); ?></p>
  </section>
</main>

<footer><p><?php echo $cfg['branding_html']; ?></p></footer>

<script>
function shareCard(){
  const data = {title: document.title, text: 'Card', url: window.location.href};
  if(navigator.share){ navigator.share(data).catch(()=>{}); }
  else { navigator.clipboard.writeText(data.url).then(()=>alert('Link copiado!')); }
}
function sendLead(form){
  const fd = new FormData(form);
  fd.append('k','<?php echo htmlspecialchars(PUBLIC_TOKEN); ?>');
  fetch('<?php echo htmlspecialchars($cfg['base_url']); ?>/lead.php', { method:'POST', body: fd })
    .then(r=>r.json()).then(j=>{ if(j.ok){ document.getElementById('lead-ok').style.display='block'; form.reset(); } });
  return false;
}
</script>
</body></html>
