<?php
require __DIR__.'/../db.php';
require __DIR__.'/../locale_helpers.php';

if (php_sapi_name() !== 'cli') { fwrite(STDERR,"CLI only\n"); exit(1); }
$email  = $argv[1] ?? null;            // opcional
$locale = $argv[2] ?? 'pt-BR';

$locale = normalize_locale($locale);
$cfg = include __DIR__.'/../config.php';

function b64u($s){ return rtrim(strtr(base64_encode($s), '+/', '-_'), '='); }
$raw = random_bytes(16);
$code = substr(b64u($raw), 0, 22);

$pdo = db();
$exp = (int)($cfg['invite_exp_hours'] ?? 168);
$expires_at = (new DateTimeImmutable("+{$exp} hours"))->format('Y-m-d H:i:s');
$pdo->prepare("INSERT INTO invites (code,email,default_locale,expires_at) VALUES (?,?,?,?)")
    ->execute([$code,$email,$locale,$expires_at]);

$url = rtrim($cfg['base_url'],'/') . "/invite.php?c=" . urlencode($code);
echo "OK\nCode: $code\nLocale: $locale\nInvite URL: $url\n";
