<?php
require_once __DIR__.'/db.php';

function b64u($s){ return rtrim(strtr(base64_encode($s), '+/', '-_'), '='); }

function magic_create($user_id, $minutes=30, $purpose='login'){
  $raw = random_bytes(32);
  $token = b64u($raw);
  $hash = password_hash($token, PASSWORD_DEFAULT);
  $prefix = substr($token, 0, 8);
  $exp = (new DateTimeImmutable("+{$minutes} minutes"))->format('Y-m-d H:i:s');

  $pdo = db();
  $pdo->prepare("INSERT INTO magic_links (user_id, token_hash, token_prefix, purpose, expires_at)
                 VALUES (?,?,?,?,?)")
      ->execute([$user_id, $hash, $prefix, $purpose, $exp]);

  return $token; // retorne o token em claro para enviar no link
}