<?php
session_start();
require __DIR__.'/db.php';

$token = $_GET['m'] ?? '';
if (!$token){ http_response_code(400); echo "Token ausente."; exit; }

$prefix = substr($token, 0, 8);
$pdo = db();
$stmt = $pdo->prepare("SELECT * FROM magic_links WHERE token_prefix=? AND used_at IS NULL ORDER BY id DESC");
$stmt->execute([$prefix]);
$rows = $stmt->fetchAll();

$ok = null;
foreach($rows as $r){
  if (strtotime($r['expires_at']) < time()) continue;
  if (password_verify($token, $r['token_hash'])) { $ok = $r; break; }
}

if (!$ok){ http_response_code(410); echo "Link inválido ou expirado."; exit; }

// marca como usado (single-use)
$pdo->prepare("UPDATE magic_links SET used_at=NOW(), used_ip=? WHERE id=?")
    ->execute([$_SERVER['REMOTE_ADDR'] ?? '', $ok['id']]);

// cria sessão simples para o usuário
$_SESSION['user_id'] = (int)$ok['user_id'];
$_SESSION['auth_at'] = time();
$_SESSION['auth_method'] = 'magic';

// redireciona para a página que você quiser (setup, editor, painel)
header("Location: /card/admin/setup.php");
exit;