<?php
function normalize_locale($s){
  $s = str_replace('_','-',$s);
  $s = strtolower(substr($s,0,2)) . (strlen($s)>2 ? '-' . strtoupper(substr($s,3)) : '');
  // mapear atalhos
  if (stripos($s,'pt')===0) return 'pt-BR';
  if (stripos($s,'en')===0) return 'en-US';
  if (stripos($s,'es')===0) return 'es-419';
  return 'pt-BR';
}
function pick_locale($cfg){
  // prioridade: ?lang= → sessão → Accept-Language → default
  if (!empty($_GET['lang'])) {
    $l = normalize_locale($_GET['lang']);
    $_SESSION['lang'] = $l;
    return $l;
  }
  if (!empty($_SESSION['lang'])) return $_SESSION['lang'];
  $accept = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
  if ($accept) {
    $code = substr($accept,0,2);
    return normalize_locale($code);
  }
  return $cfg['default_locale'] ?? 'pt-BR';
}
