<?php
// DEBUG TEMPORÁRIO — remova depois
error_reporting(E_ALL);
ini_set('display_errors', 0);           // não exibir no browser
ini_set('log_errors', 1);
ini_set('error_log', '/var/log/consulta_api_error.log');  // log dedicado

http_response_code(200);
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/../inc/db.php';
require __DIR__ . '/../inc/auth.php';
require_login();

// modules
require __DIR__ . '/../modules/CpfQuery.php';

function jerr($msg, $code = 400, $meta = []) {
  error_log("[consulta_api] $msg " . json_encode($meta));
  http_response_code($code);
  echo json_encode([
    'text' => '',
    'info' => 'Erro',
    'page' => 1,
    'has_prev' => false,
    'has_next' => false,
    'error' => $msg,
  ], JSON_UNESCAPED_UNICODE);
  exit;
}

try {
  $raw = file_get_contents('php://input');
  $payload = json_decode($raw, true);
  if (!is_array($payload)) {
    jerr('JSON inválido no corpo da requisição', 400, ['raw'=>$raw]);
  }

  $cmd  = trim($payload['command'] ?? '');
  $args = trim($payload['args'] ?? '');
  $page = max(1, (int)($payload['page'] ?? 1));

  // timeout defensivo por sessão
  $pdo->exec("SET statement_timeout TO '8s'");

  $result = ['text'=>'', 'info'=>'Comando inválido', 'page'=>1, 'has_prev'=>false, 'has_next'=>false];

  switch (strtolower($cmd)) {
    case '/cpf':
      $result = CpfQuery::run($pdo, $args, $page, 50);
      break;
    default:
      $result['text'] = "Comando não implementado: $cmd";
      $result['info'] = "Selecione um comando no menu.";
  }

  echo json_encode($result, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  jerr('Exceção na API: '.$e->getMessage(), 500, ['trace'=>$e->getTraceAsString()]);
}