<?php
require __DIR__.'/../db.php';
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }
$uid = (int)($argv[1] ?? 0);
$locale = $argv[2] ?? '';
$jsonPath = $argv[3] ?? null;
if (!$uid || !$locale || !$jsonPath) {
  echo "Usage: php scripts/set_content_lang.php <user_id> <locale> <json_path>\n";
  exit(1);
}
if (!file_exists($jsonPath)) { echo "JSON not found\n"; exit(1); }
$raw = file_get_contents($jsonPath);
$pdo = db();
$pdo->prepare("INSERT INTO user_profiles_i18n (user_id,locale,content) VALUES (?,?,CAST(? AS JSON))
               ON DUPLICATE KEY UPDATE content=VALUES(content), updated_at=NOW()")
    ->execute([$uid,$locale,$raw]);
echo "Updated content for user_id=$uid locale=$locale\n";
