<?php
require __DIR__.'/../db.php';
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }
$uid = (int)($argv[1] ?? 0);
$jsonPath = $argv[2] ?? null;
if (!$uid || !$jsonPath) { echo "Usage: php scripts/set_content.php <user_id> <path_to_json>\n"; exit(1); }
if (!file_exists($jsonPath)) { echo "JSON not found\n"; exit(1); }
$raw = file_get_contents($jsonPath);
$pdo = db();
$pdo->prepare("UPDATE user_profiles SET content=CAST(? AS JSON) WHERE user_id=?")->execute([$raw, $uid]);
echo "Updated content for user_id=$uid\n";
