<?php
require __DIR__.'/../token_helpers.php';
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }

$email = $argv[1] ?? null;
$name  = $argv[2] ?? null;
if (!$email || !$name) {
  echo "Usage: php scripts/create_user.php email@dominio Nome Sobrenome\n";
  exit(1);
}

try {
  $uid = create_user($email, $name);
  $token = create_user_token($uid, 'Public', 'public', null);
  $cfg = include __DIR__.'/../config.php';
  echo "OK\nUser ID: $uid\nToken: $token\nURL: " . rtrim($cfg['base_url'],'/') . "/$token\n";
} catch (Throwable $e) {
  fwrite(STDERR, "ERR: ".$e->getMessage()."\n");
  exit(2);
}
