<?php $BASE="/poker"; ?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width,initial-scale=1"/>
<title>VideoPoker — MVP</title>
<script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
<style>
body {
    font-family: system-ui, Segoe UI, Roboto, Arial, sans-serif;
    background: #f8fafc;
    color: #0f172a;
    margin: 0
}
.wrap {
    max-width: 1100px;
    margin: 24px auto;
    padding: 0 16px
}
.card {
    background: #fff;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    box-shadow: 0 1px 3px rgba(0,0,0,.05);
    padding: 16px;
    margin-bottom: 16px
}
.btn {
    border: 1px solid #cbd5e1;
    background: #0ea5e9;
    color: #fff;
    border-radius: 10px;
    padding: 10px 14px;
    cursor: pointer;
    font-weight: 600
}
.btn.secondary {
    background: #64748b;
    border-color: #64748b
}
.btn.warn {
    background: #ef4444;
    border-color: #ef4444
}
.btn:disabled {
    opacity: .5;
    cursor: not-allowed
}
.row {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
    align-items: center
}
.col {
    flex: 1
}
.pill {
    background: #e2e8f0;
    border-radius: 999px;
    padding: 6px 10px;
    font-size: 12px
}
.grid5 {
    display: grid;
    grid-template-columns: repeat(5, 1fr);
    gap: 10px
}
.grid47 {
    display: grid;
    grid-template-columns: repeat(12, 1fr);
    gap: 6px
}
.kpi {
    font-size: 13px;
    color: #334155
}
.hold {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 6px;
    padding: 8px;
    border: 1px dashed #cbd5e1;
    border-radius: 10px
}
.hold input {
    transform: scale(1.2)
}
.cardface {
    font-weight: 700;
    font-size: 18px;
    border: 1px solid #cbd5e1;
    border-radius: 10px;
    padding: 16px;
    text-align: center;
    background: #fff
}
.idxbtn {
    border: 1px solid #cbd5e1;
    background: #fff;
    border-radius: 8px;
    padding: 8px;
    cursor: pointer
}
.idxbtn.used {
    background: #e5e7eb;
    color: #6b7280
}
.muted {
    color: #64748b
}
.mono {
    font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, "Liberation Mono", monospace
}
table {
    border-collapse: collapse;
    width: 100%
}
th, td {
    border: 1px solid #e2e8f0;
    padding: 8px;
    text-align: left;
    font-size: 14px
}
th {
    background: #f1f5f9
}
.facebox {
    border: 1px solid #cbd5e1;
    background: #fff;
    border-radius: 8px;
    padding: 8px;
    text-align: center
}
.facebox.bought {
    background: #dcfce7;
    border-color: #86efac
}
.facebox.notbought {
    background: #f1f5f9
}
.badge {
    display: inline-block;
    background: #e2e8f0;
    border-radius: 999px;
    padding: 4px 8px;
    margin: 0 6px 6px 0;
    font-size: 12px
}
</style>
</head>
<body>
<div class="wrap" x-data="pokerApp('<?php echo $BASE; ?>')">
  <div class="card">
    <h3 style="margin-top:0">Sua mão (5 cartas)</h3>
    <div class="grid5">
      <template x-for="(c, i) in hand5" :key="'h'+i">
        <div class="hold">
          <div class="cardface" x-text="cardLabel(c)"></div>
          <label>
            <input type="checkbox" x-model="holds[i]" @change="onHoldChange()" :disabled="!started || loading || gameOver">
            HOLD</label>
        </div>
      </template>
    </div>
    <div style="margin-top:10px">
      <div class="muted" style="margin-bottom:6px">Você pode alcançar:</div>
      <template x-if="prospects.length===0">
        <div class="muted">—</div>
      </template>
      <template x-for="p in prospects" :key="p.rank"> <span class="badge"><strong x-text="p.rank"></strong>: <span class="mono" x-text="fmt(p.payout)"></span> <span class="muted">(x<span x-text="p.mult"></span>)</span></span> </template>
    </div>
  </div>
  <template x-if="!gameOver">
    <div class="card">
      <h4 style="margin-top:0">Ganho</h4>
      <div class="row">
        <div class="kpi">Rank: <strong x-text="previewRank||'-'"></strong></div>
        <div class="kpi">Mult: <strong x-text="previewMultiplier||0"></strong></div>
        <div class="kpi">Payout: <strong class="mono" x-text="fmt(previewPayout)"></strong></div>
        <div class="kpi">Bet: <strong class="mono" x-text="fmt(previewBetBase)"></strong></div>
      </div>
    </div>
  </template>
  <div class="card">
    <h3 style="margin-top:0">47 cartas</h3>
    <template x-if="!gameOver">
      <div>
        <p class="muted" style="margin-top:-6px">Clique nas posições; um clique **adiciona**, outro clique **remove**.</p>
        <div class="grid47">
          <template x-for="(used, idx) in takenMask47" :key="'r'+idx">
            <button class="idxbtn" :class="{'used': used || picks.includes(idx)}"
                    @click="togglePick(idx)"
                    :disabled="used || loading || !started"
                    x-text="idx"></button>
          </template>
        </div>
        <div class="row" style="margin-top:12px">
          <div class="kpi">Picks: <span class="mono" x-text="JSON.stringify(picks)"></span></div>
          <button class="btn" @click="draw()" :disabled="loading || picks.length===0">Draw</button>
          <div class="kpi pill">Trocas: <strong x-text="k"></strong> / 15</div>
        </div>
      </div>
    </template>
    <template x-if="gameOver">
      <div>
        <p class="muted" style="margin-top:-6px">Revelação final — verde = compradas.</p>
        <div class="grid47">
          <template x-for="(cid, idx) in remaining47" :key="'f'+idx">
            <div class="facebox" :class="takenMask47[idx] ? 'bought':'notbought'">
              <div class="mono muted" style="font-size:12px;margin-bottom:4px" x-text="idx"></div>
              <div class="cardface" style="padding:6px" x-text="cardLabel(cid)"></div>
            </div>
          </template>
        </div>
            <div class="card">
    <h3 style="margin-top:0">Resultado (pago ao finalizar)</h3>
    <div class="row">
      <div class="col">
        <div class="kpi">Rank: <strong x-text="rank||'-'"></strong></div>
        <div class="kpi">Multiplier: <strong x-text="mult||0"></strong></div>
        <div class="kpi">Payout: <strong class="mono" x-text="fmt(payout)"></strong></div>
      </div>
      <div class="col">
        <div class="kpi">betBase (última): <strong class="mono" x-text="fmt(betBase)"></strong></div>
        <div class="kpi">ServerSeed: <span class="mono muted" x-text="serverSeed? (serverSeed.slice(0,16)+'…'): '-'"></span></div>
      </div>
    </div>
  </div>
      </div>
    </template>
  </div>
  <div class="card">
    <div class="row" style="margin-top:12px">
      <label>Aposta em créditos:
        <input type="number" min="1" step="1" x-model.number="bet0" :disabled="gameOver"
              style="padding:6px;border:1px solid #cbd5e1;border-radius:8px">
      </label>
      <label>clientSeed:
        <input type="text" x-model="clientSeed" :disabled="gameOver"
              style="padding:6px;border:1px solid #cbd5e1;border-radius:8px">
      </label>
      <button class="btn" @click="start()" :disabled="loading">Start</button>
      <button class="btn secondary" @click="finish()" :disabled="loading || !started || gameOver">Finish & Payout</button>
      <button class="btn warn" @click="reveal()" :disabled="!revealedReady">Reveal</button>
    </div>
    <div class="row">
      <div class="kpi pill">Saldo: <strong class="mono" x-text="fmt(balance)"></strong></div>
      <div class="kpi pill">Aposta da rodada: <strong class="mono" x-text="fmt(betNow)"></strong></div>
      <div class="kpi pill">Taxa de risco (rodada): <strong class="mono" x-text="fmt(riskNow)"></strong></div>
      <div class="kpi pill">Débito desta rodada: <strong class="mono" x-text="fmt(debitNow)"></strong></div>
    </div>
    <div class="row" style="margin-top:8px">
      <div class="kpi pill">Total apostado: <strong class="mono" x-text="fmt(totalBet)"></strong></div>
      <div class="kpi pill">Total taxa de risco: <strong class="mono" x-text="fmt(totalRisk)"></strong></div>
      <div class="kpi pill">Total debitado: <strong class="mono" x-text="fmt(totalDebited)"></strong></div>
    </div>
  </div>
  <div class="card">
    <h3 style="margin-top:0">Tabela de Premiação (Jacks or Better)</h3>
    <table>
      <thead>
        <tr>
          <th>Mão</th>
          <th>Multiplicador</th>
          <th>Prêmio (aposta da rodada)</th>
        </tr>
      </thead>
      <tbody>
        <template x-for="row in paytableDetailed" :key="row.rank">
          <tr>
            <td x-text="row.rank"></td>
            <td x-text="row.mult"></td>
            <td class="mono" x-text="fmt(row.payout)"></td>
          </tr>
        </template>
      </tbody>
    </table>
  </div>
  <!-- Botão de reset -->
  <div class="card" style="margin-top:-8px">
    <div class="row">
      <button class="btn warn" @click="resetCredits()" :disabled="loading">Resetar Créditos</button>
      <div class="muted">Repõe o saldo e limpa a mão atual (para testes).</div>
    </div>
  </div>

</div>
<script>
function pokerApp(BASE){
  return {
    bet0: 100, clientSeed: 'meuseed',
    balance: 0, k: 0, started:false, loading:false, gameOver:false,
    betNow: 0, riskNow: 0, debitNow: 0,
    totalBet: 0, totalRisk: 0, totalDebited: 0,
    hand5: [], holds: [false,false,false,false,false],
    takenMask47: Array(47).fill(false), remaining47: [],
    picks: [],
    previewRank:null, previewMultiplier:0, previewPayout:0, previewBetBase:0,
    rank:null, mult:0, payout:0, betBase:0,
    serverSeedHash:null, serverSeed:null, revealedReady:false,
    paytableDetailed: [], prospects: [],

    fmt(v){ return (v/100).toLocaleString('en-US',{style:'currency',currency:'USD'}); },
    cardLabel(id){
      if(id===null || id===undefined) return '–';
      const ranks=['A','2','3','4','5','6','7','8','9','10','J','Q','K'];
      const suits=['♠','♥','♦','♣'];
      const r = ranks[id%13], s=suits[Math.floor(id/13)];
      return r + ' ' + s;
    },

    async start(){
      this.loading=true;
      Object.assign(this, {
        k:0, betNow:0, riskNow:0, debitNow:0,
        totalBet:0, totalRisk:0, totalDebited:0,
        hand5:[], holds:[false,false,false,false,false],
        takenMask47:Array(47).fill(false), remaining47:[],
        picks:[], rank:null, mult:0, payout:0, betBase:0,
        previewRank:null, previewMultiplier:0, previewPayout:0, previewBetBase:0,
        serverSeedHash:null, serverSeed:null, revealedReady:false, gameOver:false,
        paytableDetailed:[], prospects:[]
      });
      try{
        const r = await fetch(`${BASE}/api/start`, {method:'POST', headers:{'Content-Type':'application/json'},
          body: JSON.stringify({bet0:this.bet0, clientSeed:this.clientSeed})});
        const j = await r.json();
        this.serverSeedHash = j.serverSeedHash;
        this.hand5 = j.hand5; this.balance = j.balance; this.k=j.k;
        this.betNow=j.betNow; this.riskNow=j.riskNow; this.debitNow=j.debitNow;
        this.totalBet=j.totalBet; this.totalRisk=j.totalRisk; this.totalDebited=j.totalDebited;
        this.previewRank=j.previewRank; this.previewMultiplier=j.previewMultiplier;
        this.previewBetBase=j.previewBetBase; this.previewPayout=j.previewPayout;
        this.paytableDetailed = j.paytableDetailed || [];
        this.prospects = j.prospects || [];
        this.started = true;
      }finally{ this.loading=false; }
    },

    async onHoldChange(){
      if(this.gameOver || !this.started) return;
      const r = await fetch(`${BASE}/api/hold`, {method:'POST', headers:{'Content-Type':'application/json'},
        body: JSON.stringify({holds:this.holds})});
      const j = await r.json();
      if(j.error) { alert(j.error); return; }
      this.paytableDetailed = j.paytableDetailed || this.paytableDetailed;
      this.prospects = j.prospects || [];
    },

    togglePick(idx){
      if(this.gameOver) return;
      if(this.takenMask47[idx]) return;
      const i = this.picks.indexOf(idx);
      if(i>=0){ this.picks.splice(i,1); return; }
      const need = this.holds.filter(h=>!h).length - this.picks.length;
      if(need<=0) return;
      this.picks.push(idx);
    },

    async draw(){
      if(this.gameOver || this.picks.length===0) return;
      this.loading=true;
      try{
        await this.onHoldChange();
        const r = await fetch(`${BASE}/api/draw`, {method:'POST', headers:{'Content-Type':'application/json'},
          body: JSON.stringify({picks:this.picks})});
        const j = await r.json();
        if(j.error){ alert(j.error); return; }
        this.hand5 = j.newHand; this.k=j.k; this.balance=j.balance;
        this.betNow=j.betNow; this.riskNow=j.riskNow; this.debitNow=j.debitNow;
        this.totalBet=j.totalBet; this.totalRisk=j.totalRisk; this.totalDebited=j.totalDebited;
        this.takenMask47 = j.takenMask47;
        this.previewRank=j.previewRank; this.previewMultiplier=j.previewMultiplier;
        this.previewBetBase=j.previewBetBase; this.previewPayout=j.previewPayout;
        this.paytableDetailed = j.paytableDetailed || this.paytableDetailed;
        this.prospects = j.prospects || [];
        this.picks=[];
      }finally{ this.loading=false; }
    },

    async finish(){
      if(!this.started || this.gameOver) return;
      this.loading=true;
      try{
        const r = await fetch(`${BASE}/api/finish`, {method:'POST', headers:{'Content-Type':'application/json'}, body:'{}'});
        const j = await r.json();
        if(j.error){ alert(j.error); return; }
        this.rank=j.rank; this.mult=j.multiplier; this.payout=j.payout; this.betBase=j.betBase; 
        this.balance=j.balance; this.revealedReady=true;
        this.gameOver = true;
        this.remaining47 = j.remaining47;
        this.takenMask47 = j.takenMask47;
        this.totalBet=j.totalBet; this.totalRisk=j.totalRisk; this.totalDebited=j.totalDebited;
      }finally{ this.loading=false; }
    },

    async reveal(){
      if(!this.revealedReady) return;
      const r = await fetch(`${BASE}/api/reveal`, {method:'POST', headers:{'Content-Type':'application/json'}, body:'{}'});
      const j = await r.json();
      this.serverSeed = j.serverSeed;
      alert('ServerSeed revelado para auditoria: ' + j.serverSeed);
    },

    async resetCredits(){
      if(this.loading) return;
      this.loading = true;
      try{
        const r = await fetch(`${BASE}/api/reset`, {method:'POST', headers:{'Content-Type':'application/json'}, body:'{}'});
        const j = await r.json();
        if(j.error){ alert(j.error); return; }
        // zera estado e aplica novo saldo
        this.balance = j.balance;
        this.k = 0; this.betNow = 0; this.riskNow = 0; this.debitNow = 0;
        this.totalBet = 0; this.totalRisk = 0; this.totalDebited = 0;
        this.hand5 = []; this.holds=[false,false,false,false,false];
        this.takenMask47 = Array(47).fill(false); this.remaining47=[];
        this.picks=[]; this.rank=null; this.mult=0; this.payout=0; this.betBase=0;
        this.previewRank=null; this.previewMultiplier=0; this.previewPayout=0; this.previewBetBase=0;
        this.serverSeedHash=null; this.serverSeed=null; this.revealedReady=false; this.gameOver=false;
        this.paytableDetailed=[]; this.prospects=[]; this.started=false;
        alert(j.message || 'Créditos resetados.');
      } finally { this.loading=false; }
    }
  }
}
</script>
</body>
</html>

<!-- Versão do app (rodapé simples) -->
<div style="max-width:1100px;margin:12px auto 24px;padding:0 16px;color:#64748b;font-size:12px" x-data="{v:''}" x-init="fetch('<?php echo $BASE; ?>/api/version',{method:'POST'}).then(r=>r.json()).then(j=>v=j.version||'');">Versão:<span x-text="v"></span></div>
