<?php $BASE="/poker-v1.1"; ?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width,initial-scale=1"/>
<title>VideoPoker — v1.1 UI (pág.3)</title>
<link rel="stylesheet" href="<?php echo $BASE; ?>/style-v11.css">
<script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body>
<div class="wrap" x-data="pokerApp('<?php echo $BASE; ?>')">
  <div class="grid-portrait">
    <div class="grid-landscape">

      <div class="panel top">
        <div class="row" style="justify-content:space-between">
          <div class="row">
            <div class="logo" aria-label="logo"></div>
            <button class="btn-img btn-sair" data-label="SAIR" title="Sair"></button>
          </div>
          <div class="row">
            <button class="btn-img btn-max" data-label="MAX" title="Maximizar"></button>
            <button class="btn-img btn-min" data-label="MIN" title="Minimizar"></button>
          </div>
        </div>
      </div>

      <div class="panel kpis">
        <div class="row">
          <div class="kpi">Créditos: <strong x-text="fmt(balance)"></strong></div>
          <div class="kpi">Aposta: <strong x-text="fmt(betNow)"></strong></div>
          <div class="kpi">Extra: <strong x-text="fmt(riskNow)"></strong></div>
          <div class="kpi">Ganho: <strong x-text="fmt(payout)"></strong></div>
        </div>
      </div>

      <div class="panel prizes">
        <div class="row muted" style="margin-bottom:6px">Prêmios (ordem decrescente)</div>
        <div class="row" style="flex-wrap:wrap">
          <template x-for="row in paytableDetailed" :key="row.rank">
            <span class="badge"><strong x-text="row.rank"></strong> — x<span x-text="row.mult"></span> · <span class="mono" x-text="fmt(row.payout)"></span></span>
          </template>
        </div>
      </div>

      <div class="panel deck">
        <div class="grid47">
          <template x-for="(used, idx) in takenMask47" :key="'r'+idx">
            <div class="cardwrap sm">
              <button class="cardimg" :class="{'buy-mark': picks.includes(idx)}"
                      :style="bgBackSm()" @click="togglePick(idx)" :disabled="used || loading || !started" title="Selecionar carta">
                <span class="idx-overlay" x-text="idx"></span>
              </button>
            </div>
          </template>
        </div>
      </div>

      <div class="panel side" style="display:none"></div>

      <div class="panel msg">
        <div class="mono" x-text="statusMessage"></div>
      </div>

      <div class="panel hand">
        <div class="grid5">
          <template x-for="(c,i) in hand5" :key="'h'+i">
            <div class="cardwrap">
              <div class="cardimg" :style="bgCard(c)">
                <div class="cardlabel" x-text="cardLabel(c)"></div>
              </div>
              <div class="hold-badge" x-show="holds[i]">HOLD</div>
              <label style="position:absolute;bottom:8px;left:8px;background:#fff;padding:4px 6px;border-radius:6px;font-size:12px">
                <input type="checkbox" x-model="holds[i]" @change="onHoldChange()" :disabled="!started || loading || gameOver"> Fixar
              </label>
            </div>
          </template>
        </div>
      </div>

      <div class="panel actions">
        <div class="row" style="justify-content:center">
          <button class="btn-img btn-play" data-label="PLAY"  @click="start()" :disabled="loading" title="Play"></button>
          <button class="btn-img btn-aposta" data-label="APOSTA" :disabled="true" title="Aposta (em breve)"></button>
          <button class="btn-img btn-abrir" data-label="ABRIR"  @click="draw()"   :disabled="loading || picks.length===0 || gameOver || !started" title="Abrir"></button>
          <button class="btn-img btn-parar" data-label="PARAR"  @click="finish()" :disabled="loading || !started || gameOver" title="Parar"></button>
          <button class="btn-img btn-ajuda" data-label="AJUDA"  @click="showOverlay('info-ajuda',0)" title="Ajuda"></button>
        </div>
      </div>

    </div>
  </div>

  <!-- OVERLAY -->
  <div x-show="overlayOpen" style="position:fixed;inset:0;z-index:9999;display:flex;align-items:center;justify-content:center" @keydown.escape.window="closeOverlay()">
    <div style="position:absolute;inset:0;background:rgba(0,0,0,.6)"></div>
    <div style="position:relative;max-width:min(90vw,900px);max-height:min(90vh,700px);padding:12px;background:rgba(255,255,255,.9);border-radius:16px;backdrop-filter:blur(4px)">
      <button @click="closeOverlay()" style="position:absolute;top:8px;right:8px;border:none;background:transparent;font-size:22px;cursor:pointer">✕</button>
      <img :src="overlayImg" alt="" style="max-width:100%;max-height:70vh;display:block;margin:auto"/>
    </div>
  </div>
</div>

<script>
function pokerApp(BASE){
  return {
    bet0:100, clientSeed:'meuseed',
    balance:0, betNow:0, riskNow:0, payout:0,
    k:0, started:false, loading:false, gameOver:false,
    hand5:[], holds:[false,false,false,false,false],
    takenMask47:Array(47).fill(false), remaining47:[], picks:[],
    paytableDetailed:[], previewRank:null, previewMultiplier:0, previewPayout:0, previewBetBase:0,
    statusMessage:'',
    overlayOpen:false, overlayImg:'', overlayAutocloseMs:0,
    showOverlay(name, ms=0){ this.overlayImg=`${BASE}/assets/skin/default/overlays/${name}.svg`; this.overlayOpen=true; if(ms>0){ setTimeout(()=>this.overlayOpen=false, ms); } },
    closeOverlay(){ this.overlayOpen=false; },
    fmt(v){ return (v/100).toLocaleString('en-US',{style:'currency',currency:'USD'}); },
    cardCode(id){ const r=['A','2','3','4','5','6','7','8','9','10','J','Q','K']; const s=['S','H','D','C']; return r[id%13]+s[Math.floor(id/13)]; },
    cardLabel(id){ const r=['A','2','3','4','5','6','7','8','9','10','J','K']; const s=['♠','♥','♦','♣']; return r[id%13]+' '+s[Math.floor(id/13)]; },
    bgCard(id){ return `background-image:url('${BASE}/assets/skin/default/cards/${this.cardCode(id)}.svg')`; },
    bgBackSm(){ return `background-image:var(--card-back)`; },

    async start(){
      this.loading=true;
      if(this.gameOver){ Object.assign(this,{k:0,betNow:0,riskNow:0,payout:0,hand5:[],holds:[false,false,false,false,false],takenMask47:Array(47).fill(false),remaining47:[],picks:[],previewRank:null,previewMultiplier:0,previewPayout:0,previewBetBase:0,gameOver:false,statusMessage:''}); }
      try{
        const r=await fetch(`${BASE}/api/start`,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({bet0:this.bet0,clientSeed:this.clientSeed})});
        const j=await r.json(); if(j.error){ alert(j.error); return; }
        this.hand5=j.hand5; this.balance=j.balance; this.k=j.k; this.betNow=j.betNow; this.riskNow=j.riskNow;
        this.previewRank=j.previewRank; this.previewMultiplier=j.previewMultiplier; this.previewBetBase=j.previewBetBase; this.previewPayout=j.previewPayout;
        this.paytableDetailed=j.paytableDetailed||[]; this.started=true;
        this.statusMessage = this.previewRank ? `Mão inicial: ${this.previewRank} · Pagaria ${this.fmt(this.previewPayout)}` : 'Mão inicial aberta.';
      } finally { this.loading=false; }
    },

    async onHoldChange(){
      if(this.gameOver || !this.started) return;
      const r=await fetch(`${BASE}/api/hold`,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({holds:this.holds})});
      const j=await r.json(); if(j.error){ alert(j.error); return; }
      this.paytableDetailed=j.paytableDetailed||this.paytableDetailed;
      this.statusMessage='Ajuste de HOLD aplicado.';
    },

    togglePick(idx){
      if(this.gameOver || !this.started || this.takenMask47[idx]) return;
      const i=this.picks.indexOf(idx);
      if(i>=0){ this.picks.splice(i,1); return; }
      const need=this.holds.filter(h=>!h).length - this.picks.length;
      if(need<=0) return;
      this.picks.push(idx);
    },

    async draw(){
      if(this.gameOver || !this.started || this.picks.length===0) return;
      this.loading=true;
      try{
        const r=await fetch(`${BASE}/api/draw`,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({picks:this.picks})});
        const j=await r.json(); if(j.error){ alert(j.error); return; }
        this.hand5=j.newHand; this.k=j.k; this.balance=j.balance; this.betNow=j.betNow; this.riskNow=j.riskNow;
        this.takenMask47=j.takenMask47; this.picks=[];
        this.previewRank=j.previewRank; this.previewMultiplier=j.previewMultiplier; this.previewBetBase=j.previewBetBase; this.previewPayout=j.previewPayout;
        this.statusMessage = this.previewRank ? `Pré-visualização: ${this.previewRank} · Pagaria ${this.fmt(this.previewPayout)}` : 'Sem prêmio no preview.';
      } finally { this.loading=false; }
    },

    async finish(){
      if(!this.started || this.gameOver) return;
      this.loading=true;
      try{
        const r=await fetch(`${BASE}/api/finish`,{method:'POST',headers:{'Content-Type':'application/json'},body:'{}'});
        const j=await r.json(); if(j.error){ alert(j.error); return; }
        this.payout=j.payout; this.balance=j.balance; this.gameOver=true;
        this.remaining47=j.remaining47; this.takenMask47=j.takenMask47;
        this.statusMessage = j.rank ? `Resultado: ${j.rank} · Pagou ${this.fmt(j.payout)}` : 'Sem prêmio.';
      } finally { this.loading=false; }
    }
  }
}
</script>
</body>
</html>
