<?php
// playfantasy/api/auth_gamelist.php (ETAPA 1)
// Teste simples: autentica (HMAC) e retorna a Game List.
// ATENÇÃO: Estes valores estão hardcoded apenas para teste inicial.

declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

// ====== SEUS DADOS DE TESTE ======
$oper_id    = 'playfantasy';          // mapeado para casino_id
$auth_token = 'tRpXaGwJQ8vN2zK';      // AUTH_TOKEN
$session_id = date("YmdHis") . substr((string)microtime(), 2, 4); // não usado no game/list
$locale     = 'pt';                    // não usado no game/list
$currency   = 'BRL';                   // não usado no game/list

// GS_URL de teste (da documentação)
$GS_URL = 'https://prod3.platipusgaming.com/psw/game/session'; //  [oai_citation:1‡GS-Platipus Integration API v1.9.6 1.pdf](file-service://file-HJ67mitUpme9n5a1EpexVg)

// ====== CORS (liberar no teste; afinamos depois) ======
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

// ====== assinatura HMAC-SHA256 exigida pela doc ======
function calc_signature(string $body, string $secret): string {
    return hash_hmac('sha256', $body, $secret);
}

// ====== monta chamada ao /game/list ======
// Doc: request exige { "casino_id": "..." }   [oai_citation:2‡GS-Platipus Integration API v1.9.6 1.pdf](file-service://file-HJ67mitUpme9n5a1EpexVg)
$payload = ["casino_id" => $oper_id];
$body    = json_encode($payload, JSON_UNESCAPED_SLASHES);

// Header X-REQUEST-SIGN = HMAC(body, AUTH_TOKEN)   [oai_citation:3‡GS-Platipus Integration API v1.9.6 1.pdf](file-service://file-HJ67mitUpme9n5a1EpexVg)
$sign = calc_signature($body, $auth_token);

$ch = curl_init(rtrim($GS_URL,'/').'/game/list');
curl_setopt_array($ch, [
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $body,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/json',
        'X-REQUEST-SIGN: '.$sign
    ],
    CURLOPT_TIMEOUT        => 15,
]);
$res  = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err  = curl_error($ch);
curl_close($ch);

if ($res === false || $code >= 400) {
    http_response_code(502);
    echo json_encode(["status"=>"ERROR","error"=>"upstream","description"=>$err ?: "HTTP $code"]);
    exit;
}

$decoded = json_decode($res, true);
if (!is_array($decoded)) {
    http_response_code(502);
    echo json_encode(["status"=>"ERROR","error"=>"bad_json","description"=>"Invalid upstream JSON"]);
    exit;
}

// Resposta típica da doc inclui: status=OK e data[] com game_id, name, category   [oai_citation:4‡GS-Platipus Integration API v1.9.6 1.pdf](file-service://file-HJ67mitUpme9n5a1EpexVg)
$out = ["status" => $decoded["status"] ?? "ERROR", "data" => []];

if (($decoded["status"] ?? "") === "OK" && isset($decoded["data"]) && is_array($decoded["data"])) {
    foreach ($decoded["data"] as $g) {
        $out["data"][] = [
            "game_id"  => $g["game_id"] ?? null,
            "name"     => $g["name"] ?? null,
            "category" => $g["category"] ?? null
        ];
    }
}

echo json_encode($out, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

// $count = count($decoded['data'] ?? []);
// echo "Total: $count jogos\n";