<?php
require __DIR__ . '/inc/db.php';
require __DIR__ . '/inc/auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $user = trim($_POST['user'] ?? '');
  $pass = trim($_POST['pass'] ?? '');
  if ($user !== '' && $pass !== '') {
    $stmt = $pdo->prepare("SELECT id, username, password_hash FROM public.users_sys WHERE username = :u");
    $stmt->execute([':u' => $user]);
    $row = $stmt->fetch();
    if ($row) {
      // Verifica usando crypt no servidor:
      $check = $pdo->prepare("SELECT crypt(:p, :hash) = :hash AS ok");
      $check->execute([':p' => $pass, ':hash' => $row['password_hash']]);
      $ok = (bool)$check->fetchColumn();
      if ($ok) {
        $_SESSION['uid'] = (int)$row['id'];
        $_SESSION['uname'] = $row['username'];
        $pdo->prepare("UPDATE public.users_sys SET last_login = now() WHERE id = :id")->execute([':id' => $row['id']]);
        header('Location: /consulta/app.php');
        exit;
      }
    }
    $err = "Usuário ou senha inválidos.";
  } else {
    $err = "Informe usuário e senha.";
  }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Login — GLJET Consulta</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="min-height:100vh">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-sm-10 col-md-6 col-lg-4">
        <div class="card shadow-sm">
          <div class="card-body">
            <h1 class="h5 mb-3 text-center">GLJET Consulta</h1>
            <?php if (!empty($err)): ?>
              <div class="alert alert-danger py-2"><?= htmlspecialchars($err) ?></div>
            <?php endif; ?>
            <form method="post" autocomplete="off">
              <div class="mb-3">
                <label class="form-label">Usuário</label>
                <input name="user" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Senha</label>
                <input name="pass" type="password" class="form-control" required>
              </div>
              <button class="btn btn-primary w-100">Entrar</button>
            </form>
          </div>
        </div>
        <p class="text-center text-muted mt-3 small">admin / @dm!3</p>
      </div>
    </div>
  </div>
</body>
</html>