<?php
require __DIR__ . '/../inc/db.php';
require __DIR__ . '/../inc/auth.php';
require_login();
require __DIR__ . '/../modules/CpfQuery.php';

$cmd  = $_GET['c'] ?? '';
$args = $_GET['a'] ?? '';
$page = max(1, (int)($_GET['p'] ?? 1));

switch (strtolower($cmd)) {
  case '/cpf':
    $res = CpfQuery::run($pdo, $args, $page, 1000);
    $txt = $res['text'] ?? '';
    $fname = 'export_' . preg_replace('/\W+/','_', $cmd . '_' . $args) . '.txt';
    header('Content-Type: text/plain; charset=utf-8');
    header('Content-Disposition: attachment; filename="'.$fname.'"');
    echo $txt;
    exit;
  default:
    http_response_code(400);
    echo "Comando não implementado.";
}