<?php
require_once __DIR__.'/db.php';

function base64url_encode($s){ return rtrim(strtr(base64_encode($s), '+/', '-_'), '='); }

function generate_uuid(){
  $d = random_bytes(16);
  $d[6] = chr((ord($d[6]) & 0x0f) | 0x40);
  $d[8] = chr((ord($d[8]) & 0x3f) | 0x80);
  return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($d), 4));
}

function generate_token_pair($len=32){
  $raw = random_bytes($len);
  $token = base64url_encode($raw);
  $prefix = substr($token, 0, 8);
  $hash = password_hash($token, PASSWORD_DEFAULT);
  return ['token'=>$token,'prefix'=>$prefix,'hash'=>$hash];
}

function create_user($email, $name){
  $pdo = db();
  $uuid = generate_uuid();
  $pdo->prepare("INSERT INTO users (uuid,email,name) VALUES (?,?,?)")->execute([$uuid,$email,$name]);
  $user_id = (int)$pdo->lastInsertId();
  $empty = json_encode([
    'profile'=>['name'=>$name,'title'=>'','avatar'=>'','whatsapp'=>'','email'=>$email,'location'=>'','accent'=>'#22c55e'],
    'links'=>new stdClass(),'posts'=>[],'photos'=>[],'videos'=>[],
    'reviews'=>['google'=>'','facebook'=>'','trustpilot'=>''],
    'integrations'=>['lead_webhook'=>'']
  ]);
  $pdo->prepare("INSERT INTO user_profiles (user_id,content) VALUES (?, CAST(? AS JSON))")->execute([$user_id,$empty]);
  return $user_id;
}

function create_user_token($user_id, $label='Public', $scope='public', $expires_at=null){
  $pdo = db();
  $pair = generate_token_pair();
  $pdo->prepare("INSERT INTO user_tokens (user_id, token_hash, token_prefix, label, scope, expires_at) VALUES (?,?,?,?,?,?)")
      ->execute([$user_id, $pair['hash'], $pair['prefix'], $label, $scope, $expires_at]);
  return $pair['token'];
}

function find_user_by_token($token){
  $pdo = db();
  $prefix = substr($token, 0, 8);
  $stmt = $pdo->prepare("SELECT t.user_id, t.token_hash, t.revoked, t.expires_at FROM user_tokens t WHERE t.token_prefix=? AND t.revoked=0");
  $stmt->execute([$prefix]);
  $rows = $stmt->fetchAll();
  foreach($rows as $r){
    if ($r['expires_at'] && strtotime($r['expires_at']) < time()) continue;
    if (password_verify($token, $r['token_hash'])) {
      $uid = (int)$r['user_id'];
      $p = $pdo->prepare("SELECT * FROM user_profiles WHERE user_id=?");
      $p->execute([$uid]);
      $profile = $p->fetch();
      $u = $pdo->prepare("SELECT * FROM users WHERE id=? AND status='active'");
      $u->execute([$uid]);
      $user = $u->fetch();
      if (!$user || !$profile) return null;
      return ['user'=>$user,'profile'=>$profile,'user_id'=>$uid];
    }
  }
  return null;
}
