<?php
require __DIR__.'/token_helpers.php';
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); echo json_encode(['ok'=>false,'err'=>'method']); exit; }

$token = $_POST['k'] ?? '';
$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$note = trim($_POST['note'] ?? '');

if (!$token) { http_response_code(400); echo json_encode(['ok'=>false,'err'=>'no_token']); exit; }
$ctx = find_user_by_token($token);
if (!$ctx) { http_response_code(404); echo json_encode(['ok'=>false,'err'=>'bad_token']); exit; }

if (!$name && !$email && !$phone) { http_response_code(400); echo json_encode(['ok'=>false,'err'=>'empty']); exit; }

$pdo = db();
$pdo->prepare("INSERT INTO user_leads (user_id,name,email,phone,note,ip) VALUES (?,?,?,?,?,?)")
    ->execute([$ctx['user_id'],$name,$email,$phone,$note,$_SERVER['REMOTE_ADDR'] ?? '']);

echo json_encode(['ok'=>true]);
