
<?php
session_start();
require __DIR__.'/db.php';
require __DIR__.'/token_helpers.php';
require __DIR__.'/locale_helpers.php';
require __DIR__.'/i18n.php';

$cfg = include __DIR__.'/config.php';
$token = $_GET['k'] ?? null;
if (!$token){
  header('Content-Type: text/html; charset=utf-8');
  echo "<!doctype html><meta charset='utf-8'><title>GLJET Card</title>";
  echo "<p>Use {$cfg['base_url']}/[chave]</p>";
  exit;
}
$ctx = find_user_by_token($token);
if (!$ctx){ http_response_code(404); echo "Cartão não encontrado."; exit; }

$locale = pick_locale($cfg);

// busca o perfil do idioma
$pdo = db();
$stmt = $pdo->prepare("SELECT content FROM user_profiles_i18n WHERE user_id=? AND locale=?");
$stmt->execute([$ctx['user_id'],$locale]);
$row = $stmt->fetch();

if (!$row) {
  // fallback para o primeiro idioma disponível do usuário
  $stmt2 = $pdo->prepare("SELECT locale, content FROM user_profiles_i18n WHERE user_id=? ORDER BY FIELD(locale,'pt-BR','en-US','es-419')");
  $stmt2->execute([$ctx['user_id']]);
  $row = $stmt2->fetch();
  if ($row) $locale = $row['locale'];
}

$data = $row ? json_decode($row['content'], true) : null;

// passa variáveis ao template
define('PUBLIC_TOKEN', $token);
define('ACTIVE_LOCALE', $locale);

header('Cache-Control: no-cache, no-store, must-revalidate');
include __DIR__ . "/themes/tap/template.php";